<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-project-innovation-initiative
* @subpackage models
* @filesource
*/

/** */
require_once 'api_entity.php';

#TODO - COUNT WON'T CURRENTLY WORK (THERE'S NO COUNT RESOURCE, SO WE'LL NEED TO JUST

/**
* @package direct-project-innovation-initiative
* @subpackage models
*/
class Folder extends API_entity {
	static $find_resource = 'direct/folders';
	static $find_one_resource = 'direct/folders';
	#static $count_resource = 'direct/messages/count';
	
	function is_custom_folder(){
		return is_numeric($this->id);
	}	
	
	function name_for_display(){
		if($this->is_custom_folder()){
			return strip_from_beginning(CUSTOM_MAILBOX_PREFIX, $this->name);
		}
		return $this->name;
	}
	
/////////////////////////
// STATIC
/////////////////////////	
	
	//overrides parent because we don't have a count resource for folders	
    public static function count($id_or_conditions = array()){
		return count(static::find($id_or_conditions));
    }
	
	public static function fields(){
		return array('id', 'name');  
    }	
	
	public static function find($id_or_conditions = array(), $key_by = null){
		$results = parent::find($id_or_conditions, $key_by);
		
		//since we don't actually have find_one behavior for folders, emulate this by checking to see if we have the primary key in the conditions
		$primary_key = static::$primary_key;   
		$conditions = static::_conditions_for_find($id_or_conditions);	
		if(!array_key_exists($primary_key, $conditions)) return $results;
		
		foreach($results as $key => $folder){
			if($folder->id == $conditions[$primary_key])
				return array($key => $folder);	
		}
		
		return array(); //if none of the results matched the id, we have no results
    }
	
	
	
	protected static function _results_from_api_output(){
		$output = parent::_results_from_api_output();
		
		if(!is_array($output) || !array_key_exists('folder', $output))
			return array();
			
		return $output['folder'];
	}
	
	
	protected static function _conditions_for_find($id_or_conditions){
		$conditions = parent::_conditions_for_find($id_or_conditions);
		$CI = get_instance();
		//make sure we have a mailbox - assume that it's the current mailbox if not otherwise specified
		if(!array_key_exists('mailbox', $conditions) && isset($CI->mailbox)){
			$conditions['mailbox'] = $CI->mailbox->name;
		}
		return $conditions;	
	}		
	
	
	
	
		
}
